#include <windows>
#include <initguid>
#pragma option push -a1
   #include <setupapi>
#pragma option pop
#include <iostream>
#include "D:\\WINDDK\\7600.16385.1\\inc\\api\\usbioctl.h"
//#include "D:\\Program Files\\Windows Kits\\8.0\\include\\shared\\usbioctl.h"
using namespace std;
//-----------------------------------------------------
void displayError(const char* msg){
  cout << msg << endl;
  system("PAUSE");
  exit(0);
};
//---------------------------------------------------------
void getDSPortConnectionIndex(HANDLE devHandle, UCHAR connectionIndex) 
{
  USB_NODE_CONNECTION_NAME  connectionName;
  PUSB_NODE_CONNECTION_NAME pConnectionName;
  ULONG outBufferSize = 0;
  ULONG bytesReturned;
  bool success;
  memset(&connectionName, 0, sizeof(connectionName));
  connectionName.ConnectionIndex = connectionIndex;

  success = DeviceIoControl(devHandle,
            IOCTL_USB_GET_NODE_CONNECTION_NAME,
            &connectionName, sizeof(connectionName),
            &connectionName, sizeof(connectionName),
            &outBufferSize, NULL);
  if (success) {
     outBufferSize = connectionName.ActualLength;
     pConnectionName = new USB_NODE_CONNECTION_NAME[outBufferSize];
     pConnectionName->ConnectionIndex = connectionIndex;
     if (DeviceIoControl(devHandle,
         IOCTL_USB_GET_NODE_CONNECTION_NAME,
         pConnectionName, outBufferSize, pConnectionName,
         outBufferSize, &bytesReturned, NULL)) {
         printf("USB_NODE_CONNECTION_NAME.ConnectionIndex: %d\n",
                pConnectionName->ConnectionIndex);
         //printf("USB_NODE_CONNECTION_NAME.NodeName: %ls\n",
         //        pConnectionName->NodeName[0]);
     };
     delete [] pConnectionName;
  };
};
//---------------------------------------------------------
USHORT getNumberOfPorts(HANDLE devHandle)
{
    ULONG  bytesReturned;
    bool   success;
    USHORT nDSPorts = 0; //Liczba dostpnych portw huba
    USB_NODE_INFORMATION nodeInformation;

    success = DeviceIoControl(devHandle,
              IOCTL_USB_GET_NODE_INFORMATION, &nodeInformation,
              sizeof(nodeInformation), &nodeInformation,
              sizeof(nodeInformation), &bytesReturned, NULL);
    if ((success) && (nodeInformation.NodeType == UsbHub))
        nDSPorts = nodeInformation.u.HubInformation.\
                   HubDescriptor.bNumberOfPorts;
    return nDSPorts;
}
//---------------------------------------------------------
void getDSPortData(HANDLE devHandle, UCHAR connectionIndex)
{
   ULONG bytesReturned;
   bool success;
   PUSB_NODE_CONNECTION_INFORMATION pConnectionInformation = NULL;

   ULONG nBytes = sizeof(USB_NODE_CONNECTION_INFORMATION) +
                  sizeof(USB_PIPE_INFO) * 30; //15 EP IN + 15 EP OUT

   pConnectionInformation = new USB_NODE_CONNECTION_INFORMATION[nBytes];
   pConnectionInformation->ConnectionIndex = connectionIndex;
   success = DeviceIoControl(devHandle,
             IOCTL_USB_GET_NODE_CONNECTION_INFORMATION,
             pConnectionInformation, nBytes,
             pConnectionInformation, nBytes,
             &bytesReturned, NULL);
   if (!success) {
      delete [] pConnectionInformation;
      return;
   }
   //patrz rozdzia 3, tabela 3.3
   printf(" \n Length:            %d\n",
            pConnectionInformation->DeviceDescriptor.bLength);
   printf(" DescriptorType:    %2.2x\n",
            pConnectionInformation->DeviceDescriptor.bDescriptorType);
   printf(" MaxPacketSize0:    %d\n",
            pConnectionInformation->DeviceDescriptor.bMaxPacketSize0);
   printf(" DeviceClass:       %2.2x\n",
            pConnectionInformation->DeviceDescriptor.bDeviceClass);
   printf(" DeviceSubClass:    %2.2x\n",
            pConnectionInformation->DeviceDescriptor.bDeviceSubClass);
   printf(" DeviceProtocol:    %2.2x\n",
            pConnectionInformation->DeviceDescriptor.bDeviceProtocol);
   printf(" dProduct:          %2.2x\n",
            pConnectionInformation->DeviceDescriptor.idProduct);
   printf(" dVendor:           %2.2x\n",
            pConnectionInformation->DeviceDescriptor.idVendor);
   printf(" NumConfigurations: %2.2x\n",
            pConnectionInformation->DeviceDescriptor.bNumConfigurations);
   printf(" Manufacturer:      %2.2x\n",
            pConnectionInformation->DeviceDescriptor.iManufacturer);
   printf(" SerialNumber:      %2.2x\n",
            pConnectionInformation->DeviceDescriptor.iSerialNumber);
   printf(" Device is LS:      %d\n",
            pConnectionInformation->LowSpeed);
   //patrz rozdzia 3, tabela 3.20         
   printf(" 	EndpointAddress:   %2.2x\n",
   pConnectionInformation->PipeList->EndpointDescriptor.bEndpointAddress);
   printf(" 	bInterval:         %d\n",
   pConnectionInformation->PipeList->EndpointDescriptor.bInterval);
   printf(" 	bmAttributes       %2.2x\n",
   pConnectionInformation->PipeList->EndpointDescriptor.bmAttributes);
   delete [] pConnectionInformation;
}
//---------------------------------------------------------
void getStringDescriptor(HANDLE devHandle, ULONG   connectionIndex,
                         UCHAR   descriptorIndex)
{
    PUSB_DESCRIPTOR_REQUEST pStringDescRequest = NULL;
    bool    success;
    ULONG   nBytes;
    ULONG   bytesReturned;
    LANGID LanguageID = 0x0409; //English (United States)
    //Language Identifiers (LANGIDs) 3/29/00 Version 1.0, USB IF 2000

    UCHAR   stringDescReqBuf[sizeof(USB_DESCRIPTOR_REQUEST) +
                             MAXIMUM_USB_STRING_LENGTH];

    nBytes = sizeof(stringDescReqBuf);
    pStringDescRequest = (PUSB_DESCRIPTOR_REQUEST)stringDescReqBuf;
    memset(pStringDescRequest, 0, nBytes);
    pStringDescRequest->ConnectionIndex = connectionIndex;

    pStringDescRequest->SetupPacket.bmRequest = 0x80;
    pStringDescRequest->SetupPacket.bRequest = USB_REQUEST_GET_DESCRIPTOR;

    pStringDescRequest->SetupPacket.wValue =
    USB_DESCRIPTOR_MAKE_TYPE_AND_INDEX(USB_STRING_DESCRIPTOR_TYPE, 
                                       descriptorIndex);
    //(USB_STRING_DESCRIPTOR_TYPE << 8) | descriptorIndex;
    pStringDescRequest->SetupPacket.wIndex=LanguageID;
    pStringDescRequest->SetupPacket.wLength=(USHORT)(nBytes -
                                           sizeof(USB_DESCRIPTOR_REQUEST));

    success = DeviceIoControl(devHandle,
                              IOCTL_USB_GET_DESCRIPTOR_FROM_NODE_CONNECTION,
                              pStringDescRequest, nBytes, pStringDescRequest,
                              nBytes, &bytesReturned, NULL);
    if (!success) {
        return;
    }
    printf("\nDeskryptor lancuchowy urzadzenia: %ls\nprzylaczonego do portu: %d\n", &pStringDescRequest->Data[2], connectionIndex);
    return;
}
//---------------------------------------------------------
PUSB_STRING_DESCRIPTOR getStringDescriptor1(HANDLE  devHandle,
                                           ULONG   connectionIndex,
                                           UCHAR   descriptorIndex)
{
    PUSB_DESCRIPTOR_REQUEST stringDescRequest = NULL;
    PUSB_STRING_DESCRIPTOR  stringDescriptor = NULL;
    PUSB_STRING_DESCRIPTOR  stringDescNode = NULL;
    bool    success;
    ULONG   nBytes;
    ULONG   bytesReturned;
    LANGID LanguageID = 0x0409;

    UCHAR   stringDescReqBuf[sizeof(USB_DESCRIPTOR_REQUEST) +
                             MAXIMUM_USB_STRING_LENGTH];

    nBytes = sizeof(stringDescReqBuf);
    stringDescRequest = (PUSB_DESCRIPTOR_REQUEST)stringDescReqBuf;
    stringDescriptor = (PUSB_STRING_DESCRIPTOR)(stringDescRequest+1);
    memset(stringDescRequest, 0, nBytes);
    stringDescRequest->ConnectionIndex = connectionIndex;

    stringDescRequest->SetupPacket.wValue=(USB_STRING_DESCRIPTOR_TYPE<<8)
                                          | descriptorIndex;
    stringDescRequest->SetupPacket.wIndex=LanguageID;
    stringDescRequest->SetupPacket.wLength=(USHORT)(nBytes -
                                          sizeof(USB_DESCRIPTOR_REQUEST));

    success = DeviceIoControl(devHandle,
                              IOCTL_USB_GET_DESCRIPTOR_FROM_NODE_CONNECTION,
                              stringDescRequest, nBytes, stringDescRequest,
                              nBytes, &bytesReturned, NULL);
    if (!success) {
        return NULL;
    }
    stringDescNode = new USB_STRING_DESCRIPTOR[(sizeof(USB_STRING_DESCRIPTOR)+
                                                stringDescriptor->bLength)];
    if (stringDescNode == NULL) {
        return NULL;
    }
    memcpy(stringDescNode, stringDescriptor, stringDescriptor->bLength);
    return stringDescNode;
}
//---------------------------------------------------------
PUSB_CONFIGURATION_DESCRIPTOR cfgDescriptor(HANDLE  devHandle,
                                            ULONG   connectionIndex,
                                            UCHAR   descriptorIndex)
{
    PUSB_DESCRIPTOR_REQUEST stringDescRequest = NULL;
    PUSB_CONFIGURATION_DESCRIPTOR  cfgDesc = NULL, cfgDescNode = NULL;
    bool    success;
    ULONG   nBytes;
    ULONG   bytesReturned;

    UCHAR   stringDescReqBuf[sizeof(USB_DESCRIPTOR_REQUEST) +
                             sizeof(USB_CONFIGURATION_DESCRIPTOR)];

    nBytes = sizeof(stringDescReqBuf);
    stringDescRequest = (PUSB_DESCRIPTOR_REQUEST)stringDescReqBuf;
    cfgDesc= (PUSB_CONFIGURATION_DESCRIPTOR)(stringDescRequest+1);
    memset(stringDescRequest, 0, nBytes);
    stringDescRequest->ConnectionIndex = connectionIndex;
    stringDescRequest->SetupPacket.bRequest=USB_REQUEST_GET_CONFIGURATION;
    stringDescRequest->SetupPacket.wValue=
    USB_DESCRIPTOR_MAKE_TYPE_AND_INDEX(USB_CONFIGURATION_DESCRIPTOR_TYPE,
                                       descriptorIndex);
    stringDescRequest->SetupPacket.wIndex=0;
    stringDescRequest->SetupPacket.wLength=(USHORT)(nBytes -
                                           sizeof(USB_DESCRIPTOR_REQUEST));

    success = DeviceIoControl(devHandle,
                              IOCTL_USB_GET_DESCRIPTOR_FROM_NODE_CONNECTION,
                              stringDescRequest, nBytes, stringDescRequest,
                              nBytes, &bytesReturned, NULL);

    if (!success) {
        return NULL;
    }
    cfgDescNode = new USB_CONFIGURATION_DESCRIPTOR[
                  (sizeof(USB_CONFIGURATION_DESCRIPTOR)+cfgDesc->bLength)];

    if (cfgDescNode == NULL) {
        return NULL;
    }
    memcpy(cfgDescNode, cfgDesc, cfgDesc->bLength);
    return cfgDescNode;
}
//---------------------------------------------------------
HANDLE openDevice(const GUID& devGUID, const char* vid)
{
   DWORD memberIndex = 0;
   DWORD deviceInterfaceDetailDataSize;
   DWORD requiredSize;
   HDEVINFO deviceInfoSet;
   SP_DEVICE_INTERFACE_DATA deviceInterfaceData;
   PSP_DEVICE_INTERFACE_DETAIL_DATA deviceInterfaceDetailData = NULL;
   HANDLE devObject = INVALID_HANDLE_VALUE;

   deviceInfoSet = SetupDiGetClassDevs(&devGUID, NULL, NULL,
                   DIGCF_PRESENT | DIGCF_INTERFACEDEVICE);
   if (deviceInfoSet == INVALID_HANDLE_VALUE)
      displayError("Nie zidentyfikowano podczonych urzdze.\n");

   deviceInterfaceData.cbSize = sizeof(SP_DEVICE_INTERFACE_DATA);
   while(SetupDiEnumDeviceInterfaces(deviceInfoSet, NULL,
                                     &devGUID, memberIndex,
                                     &deviceInterfaceData)){
       memberIndex++; //inkrementacja numeru interfejsu
       SetupDiGetDeviceInterfaceDetail(deviceInfoSet, &deviceInterfaceData,
                             NULL, 0, &deviceInterfaceDetailDataSize, NULL);
       deviceInterfaceDetailData = (PSP_DEVICE_INTERFACE_DETAIL_DATA)
                              new DWORD[deviceInterfaceDetailDataSize];
       deviceInterfaceDetailData->cbSize=sizeof(SP_DEVICE_INTERFACE_DETAIL_DATA);

       if (!SetupDiGetDeviceInterfaceDetail(deviceInfoSet, &deviceInterfaceData,
                       deviceInterfaceDetailData, deviceInterfaceDetailDataSize,
                       &requiredSize, NULL)){
           delete [] deviceInterfaceDetailData;
           SetupDiDestroyDeviceInfoList(deviceInfoSet);
       }
       if (NULL != strstr(deviceInterfaceDetailData->DevicePath, vid)){
           cout << "\n"<< deviceInterfaceDetailData->DevicePath << "\n";
           devObject=CreateFile(deviceInterfaceDetailData->DevicePath,
                                GENERIC_READ, FILE_SHARE_READ,
                                NULL,OPEN_EXISTING,0, NULL);
           if(devObject==INVALID_HANDLE_VALUE)
             displayError("Nie mona otworzy urzdzenia do transmisji");
             else
               break;
       }
       delete [] deviceInterfaceDetailData;
    };//koniec while
   SetupDiDestroyDeviceInfoList(deviceInfoSet);
   return devObject;
}
//---------------------------------------------------------
int main()
{
   const char* VID = "vid_03eb"; //Identyfikatory huba
   const char* PID = "pid_0902";
   HANDLE deviceObject = INVALID_HANDLE_VALUE;
   deviceObject = openDevice(GUID_DEVINTERFACE_USB_HUB, VID);
   USHORT nDSPorts = getNumberOfPorts(deviceObject);

   for (int i = 1; i <= nDSPorts; i++) {
      getDSPortConnectionIndex(deviceObject, i);
   }
   printf("\nLiczba portow huba = %d\n",nDSPorts);
   for (int i = 1; i<= nDSPorts; i++) {
      /*
      PUSB_STRING_DESCRIPTOR getStrDesc = getStringDescriptor1(deviceObject, i, 2);
      if (getStrDesc) {
        printf("\nDeskryptor acuchowy urzadzenia: %ls\nprzyczonego 
                do portu: %d\n", &getStrDesc->bString, i);
        getStrDesc = NULL;
      }
     */
     /*
     PUSB_CONFIGURATION_DESCRIPTOR getCfgDesc = cfgDescriptor(deviceObject, i, 2);
      if (getCfgDesc) {
        printf("\n=====Deskryptor konfiguracji=====");
        //patrz rozdzia 3, tabela 3.15
        printf("\nNumInterfaces: %d", getCfgDesc->bNumInterfaces);
        printf("\nConfigurationValue: %d", getCfgDesc->bConfigurationValue);
        printf("\nConfiguration: %d", getCfgDesc->iConfiguration);
        printf("\nDescriptorType: %d", getCfgDesc->bDescriptorType);
        printf("\nMaxPower: %d\n", getCfgDesc->MaxPower);
        getCfgDesc = NULL;
      }
      */
      getStringDescriptor(deviceObject, i, 2);
      getDSPortData(deviceObject, i);
   }
   cout <<endl;
   system("PAUSE");
   return 0;
}
//---------------------------------------------------------
 
